# Automatische Wiedervorlage

Zu jedem Vertrag kann ein Wiedervorlagedatum hinterlegt, bzw. berechnet werden. Dies ist notwendig um Kündigungsfristen nicht zu verpassen bzw. Verträge in regelmäßigen Abständen neu zu bewerten. Siehe auch <a
href="#!/guide/p83D97DC8_3179_4C49_BD79_E02E6ED4DB18">Fristen/ Laufzeiten/ Wiedervorlage</a>.

> <span
style='font-style:italic'>Ein Beispiel: Es wird ein Wartungsvertrag zu einer Software abgeschlossen. Dieser läuft ein Jahr und verlängert sich anschließend um ein weiteres Jahr. Im September eines jeden Jahres soll für den Wartungsvertrag geprüft werden, ob die Software sich noch im Einsatz befindet. Hierzu wird eine Wiedervorlagefrist von 2 Wochen gesetzt.</span>

Die Wiedervorlage kann im Bereich <span
style='font-weight:bold;font-style:italic'>Erinnerung</span> für jeden Vertrag individuell gesetzt werden.

{@img img1.png}

Wird das Wiedervorlagedatum erreicht erhält der Verantwortliche Benutzer (für den Vertrag) eine Erinnerung in Form eines Workflows.

<span class="tag_important">Der Vertragsverantwortliche kann anschließend in der Aufgabenansicht entscheiden, wie mit dem Vertrag weiter verfahren werden soll. Beispielsweise könnte die <a
href="#!/guide/p044AEA6F_B746_4E1E_95BD_EB5B29E7F4D7">Kündigung</a> eingeleitet werden.</span>

## Automatische Wiedervorlage durch den ELO AS

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch die ELOas-Regel `sol.contract.as.ContractReminder` implementiert. Diese überwacht alle Verträge und startet, falls das Wiedervorlagedatum erreicht wurde, den Workflow `sol.contract.contract.reminder`. 

{@img img3.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Knotenname deutsch und Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>CHANGEUSER : Responsible user</span></td><td><span
style='font-weight:bold'>Verantwortlichen Benutzer eintragen</span><br />Verteilungsknoten: Ändert den Eigentümer des nächsten Benutzerknotens auf den Vertragsverwantwortlichen</td><td>sol.common.ix.functions.ChangeUser</td></tr><tr><td><span
style='font-weight:bold'>Resubmission</span></td><td><span
style='font-weight:bold'>Zur Wiedervorlage</span><br />Personenknoten: Vertragsverwantwortlicher bekommt eine Aufgabe.</td><td></td></tr><tr><td><span
style='font-weight:bold'>OK</span></td><td><span
style='font-weight:bold'>OK</span><br />Verteilungsknoten: Vertragsverantwortlicher bestätigt den Erhalt und beendet die Wiedervorlage.</td><td></td></tr></tbody></table>

Soll an anderer Workflow zur Wiedervorlage der Verträge gestartet werden, kann dies in der Konfiguration des Vertragsmanagements <span
style='font-weight:bold;font-style:italic'>Laufzeiten</span> eingestellt werden.

{@img img5.png}


